# E0209: commas are not allowed between class methods

Classes and object literals have a similar syntax for declaring methods. Object
literal entries are separated by commas, but class entries are not separated by
commas. It is a syntax error to use a comma to separate class entries:

    class Doggie {
      speak() {
        console.log('woof!');
      },
      eat() {
        this.hungry = false;
      },
    }

To fix this error, remove the `,`s:

    class Doggie {
      speak() {
        console.log('woof!');
      }
      eat() {
        this.hungry = false;
      }
    }
