# E0196: new variable shadows existing variable

```config-for-examples
{
  "globals": {
    "fs": true,
    "inputPath": true,
    "path": true
  }
}
```

In JavaScript, `const` and `let` create new variables. They do not modify
existing variables. It is likely a mistake if a new variable is created with the
same name as an existing variable:

    let stream;
    if (typeof path !== 'undefined') {
      let stream = fs.createWriteStream(path);
    } else {
      let stream = fs.createWriteStream("data.txt");
    }

    const p = inputPath.replace("\\", "/");
    const dirPath = path.dirname(p);
    while (!fs.isWritable(p)) {
      const p = dirPath + "/";
    }

To fix this error, remove the 'let' or 'const' keyword to turn the declaration
into an assignment:

    let stream;
    if (typeof path !== 'undefined') {
      stream = fs.createWriteStream(path);
    } else {
      stream = fs.createWriteStream("data.txt");
    }

Alternatively, use the variable after declaring it:

    const p = inputPath.replace("\\", "/");
    const dirPath = path.dirname(p);
    while (!fs.isWritable(p)) {
      const p = dirPath + "/";
      fs.remove(p);
      fs.createDirectory(p);
    }

Introduced in quick-lint-js version 2.0.0.
