# E0194: missing parentheses around left-hand side of `**`; `**` operator cannot be used after unary `-` without parentheses

JavaScript does not allow unary operators left of a `**` expression. It is a
syntax error to write unary `-`, `+`, `!`, or `~` before a `**` expression:

    function parity(n) {
      return -1 ** n;
    }

    function notbit(bit) {
      return ~2**bit
    }

To fix this error, write parentheses around the left-hand side of the `**`
expression:

    function parity(n) {
      return (-1) ** n;
    }

Alternatively, write parentheses around the `**` expression:

    function notbit(bit) {
      return ~(2**bit)
    }

Introduced in quick-lint-js version 2.0.0.
