# E0193: misspelled React attribute; write 'className' instead

React has a different name for some attributes than HTML. It is a mistake to
write the HTML attribute instead of the React attribute:

    function Title({page}) {
      return <h1 class="title">
        <a href={page.url} class="page-link">
          {page.name}
        </a>
      </h1>;
    }

To fix this error, write the name of the attribute understood by React:

    function Title({page}) {
      return <h1 className="title">
        <a href={page.url} className="page-link">
          {page.name}
        </a>
      </h1>;
    }

Introduced in quick-lint-js version 2.0.0.
