# E0192: attribute has wrong capitalization

In HTML, attributes are case-insensitive; `colspan` is the same as `colSpan` and
`COLSPAN`. In React, attributes are case-sensitive. It is a mistake for an
attribute for a built-in element to have the wrong capitalization:

    function Header({columns}) {
      return <tr>
        <th colspan="2">Name</th>
        {columns.map(column =>
          <th colspan="1" cellpadding="5">{column}</th>)}
      </tr>;
    }

To fix this error, fix the capitalization of the attribute:

    function Header({columns}) {
      return <tr>
        <th colSpan="2">Name</th>
        {columns.map(column =>
          <th colSpan="1" cellPadding="5">{column}</th>)}
      </tr>;
    }

Introduced in quick-lint-js version 2.0.0.
