# E0189: missing '&lt;>' and '&lt;/>' to enclose multiple children

To return multiple JSX elements from a component, you must return a fragment. It
is a syntax error to return multiple elements without a fragment:

    function TodoEntry({title, children}) {
      return (
        <h3>{title}</h3>
        <div className="todo-body">{children}</div>
      );
    }

To fix this error, wrap the elements in a fragment using `<>` and `</>`:

    function TodoEntry({title, children}) {
      return <>
        <h3>{title}</h3>
        <div className="todo-body">{children}</div>
      </>;
    }

Alternatively, wrap the elements in another element:

    function TodoEntry({title, children}) {
      return <div className="todo">
        <h3>{title}</h3>
        <div className="todo-body">{children}</div>
      </div>;
    }

Introduced in quick-lint-js version 2.0.0.
