# E0187: mismatched JSX tags; expected &lt;/foo>

```config-for-examples
{
  "globals": {
    "Link": true
  }
}
```

In JSX, each opening tag must either be self-closing or have a corresponding
closing tag. It is a syntax error for the closing tag to have a different tag
name than the opening tag:

    function Section({children}) {
      return <div className="section">{children}</DIV>;
    }

    function SignUpButton() {
      return <div className="button">
        <Link to="/signup">Join <strong>now</Link></strong>
      </div>;
    }

To fix this error, make the ending tag and the opening tag use the same name:

    function Section({children}) {
      return <div className="section">{children}</div>;
    }

Alternatively, swap the incorrectly-nested closing tags:

    function SignUpButton() {
      return <div className="button">
        <Link to="/signup">Join <strong>now</strong></Link>
      </div>;
    }

Introduced in quick-lint-js version 2.0.0.
