# E0182: '>' is not allowed directly in JSX text; write {'>'} or &amp;gt; instead

In the children of a JSX element, you can write arbitrary text. However, it is a
syntax error to write `>` unescaped in JSX text:

    function Breadcrumbs({page, subpage}) {
      return <>
        <a href={page.url}>{page.name}</a> > {subpage.name}
      </>;
    }

To fix this error, write `{'>'}` or `&gt;` instead:

    function Breadcrumbs({page, subpage}) {
      return <>
        <a href={page.url}>{page.name}</a> &gt; {subpage.name}
      </>;
    }

Introduced in quick-lint-js version 2.0.0.
