# E0179: return statement returns nothing (undefined)

A `return` statement can have an optional expression. If the expression is
omitted, `undefined` is returned.

If a `return` statement has an expression, the expression must start on the same
line as the `return` keyword. If an expression starts on the next line, the
`return` statement behaves as if no expression was given, so the returned
value is `undefined` and the next line is skipped:

    function getWebsiteBaseURL() {
      return
        'https://quick-lint-js.com/';
    }
    // TypeError: URL constructor: undefined is not a valid URL.
    console.log(getWebsiteBaseURL().hostname);

To fix this error, put the returned value on the same line as the `return`
keyword:

    function getWebsiteBaseURL() {
      return 'https://quick-lint-js.com/';
    }
    // "quick-lint-js.com"
    console.log(getWebsiteBaseURL().hostname);
