# E0175: expected variable name for 'import'-'as'

```config-for-examples
{
  "globals": {
    "CE": true
  }
}
```

`import` statements load things from other files. When importing, you can pick a
different name for the imported data using the `as` keyword: It is a syntax
error to write anything except a variable name after `as`:

    import {createElement as "CE"} from "react";
    function Hello() {
      return CE('h1', null, 'Hello, world!');
    }

    import {first as "first-element"} from "./utilitylib.mjs";

To fix this error, write a variable name after `as`:

    import {createElement as CE} from "react";
    function Hello() {
      return CE('h1', null, 'Hello, world!');
    }

Alternatively, swap the left and right side of `as`:

    import {"first-element" as first} from "./utilitylib.mjs";
