# E0173: cannot assign to loop variable in for of/in loop

```config-for-examples
{
  "globals": {
    "item": true
  }
}
```

There are three kinds of `for` loops: C-style `for` loops (`;`), `for`-`in`
loops, and `for`-`of` loops. It is a syntax error to write a `for`-`in` or
`for`-`of` loop which declares a variable with `const` or `let` and initializes
the variable:

    function firstItem(collection) {
      for (const item = null of collection) {
        break;
      }
      return item;
    }

To fix this error, declare the variable outside the `for`-`in` or `for`-`of`
loop with `let`:

    function firstItem(collection) {
      let item = null;
      for (item of collection) {
        break;
      }
      return item;
    }
