# E0169: "global-groups" must be a boolean or an array

In a [quick-lint-js configuration file][], `"global-groups"` must be an array of
strings, a boolean, or omitted. It is an error if `"global-groups"` is a
boolean, a number, an object, a string, or `null`:

```quick-lint-js.config
{
    "global-groups": {
        "ecmascript": true,
        "browser": true
    }
}
```

To fix this error, make `"global-groups"` an array:

```quick-lint-js.config
{
    "global-groups": [
        "ecmascript",
        "browser"
    ]
}
```

[quick-lint-js configuration file]: https://quick-lint-js.com/config/
