# E0166: "globals" descriptor "shadowable" property must be a boolean

In a [quick-lint-js configuration file][], a entry in `"globals"` can have a
descriptor object. A descriptor's `"shadowable"` property must be either `true`,
`false`, or omitted.

```quick-lint-js.config
{
    "globals": {
        "gsap": {
          "shadowable": 0
        }
    }
}
```

To fix this error, make the `"shadowable"` property `true` or `false`:

```quick-lint-js.config
{
    "globals": {
        "gsap": {
          "shadowable": false
        }
    }
}
```

[quick-lint-js configuration file]: https://quick-lint-js.com/config/
