# E0164: JSON syntax error

[quick-lint-js configuration files][] (named `quick-lint-js.config`) contain
valid JSON (according to [RFC8259][]). quick-lint-js cannot read a configuration
file with malformed JSON:

```quick-lint-js.config
{
    "globals": {
        // Google Analytics
        "ga": true,
        "google": true,
    }
}
```

Common mistakes in JSON are trailing commas (disallowed) and comments
(disallowed).

To fix this error, correct mistakes in the JSON syntax for your configuration
file:

```quick-lint-js.config
{
    "globals": {
        " // Google Analytics": false,
        "ga": true,
        "google": true
    }
}
```

[RFC8259]: https://datatracker.ietf.org/doc/html/rfc8259
[quick-lint-js configuration files]: https://quick-lint-js.com/config/
