# E0162: 'await' is only allowed in async functions

```config-for-examples
{
  "globals": {
    "CONFIG_FILE": true,
    "fs": true,
    "parseConfig": true,
    "reallyTakeOverTheWorld": true
  }
}
```

The `await` operator can be used in `async` functions and in modules at the top
level. It is a syntax error to use the `await` operator in a non-`async`
function:

    function readConfig(configFilePath) {
      let data = await fs.promises.readFile(
        configFilePath,
        "utf-8",
      );
      return parseConfig(data);
    }

    async function takeOverTheWorld() {
      let config = readConfig(CONFIG_FILE);
      if (config.prettyPlease) {
        await reallyTakeOverTheWorld();
      }
    }

To fix this error, declare the function as `async`, ensuring that callers use
`await` too:

    async function readConfig(configFilePath) {
      let data = await fs.promises.readFile(
        configFilePath,
        "utf-8",
      );
      return parseConfig(data);
    }

    async function takeOverTheWorld() {
      let config = await readConfig(CONFIG_FILE);
      if (config.prettyPlease) {
        await reallyTakeOverTheWorld();
      }
    }
