# E0156: private properties are not allowed in object literals

```config-for-examples
{
  "globals": {
    "hashPassword": true
  }
}
```

Classes can declare private properties with `#`. `Object` cannot have private
properties. It is a syntax error to declare a private property in an object
literal:

    class Account {
      #email;
      #password;

      async save(db) {
        await db.saveAccount({
          #email,
          #passwordHash: hashPassword(this.#password),
        });
      }
    }

    class DataSmuggler {
      #contraband;

      setContraband(object, contraband) {
        return {
          ...object,
          #contraband: contraband,
        };
      }

      getContraband(object) {
        return object.#contraband;
      }
    }

To fix this error, rename the properties to exclude the `#`:

    class Account {
      #email;
      #password;

      async save(db) {
        await db.saveAccount({
          email: this.#email,
          passwordHash: hashPassword(this.#password),
        });
      }
    }

Alternatively, use a `Symbol` to attach private data to an object:

    const Contraband = Symbol('contraband');
    class DataSmuggler {
      setContraband(object, contraband) {
        return {
          ...object,
          [Contraband]: contraband,
        };
      }

      getContraband(object) {
        return object[Contraband];
      }
    }
