# E0151: invalid function parameter

```config-for-examples
{
  "globals": {
    "classes": true,
    "delimiter": true,
    "join": true
  }
}
```

A function parameter can be a variable name, an array destructuring, or an
object destructuring. It is a syntax error for a function parameter to look like
a function call or any other expression:

    const join = (string, delimiter += ",") =>
      string.join(delimiter);

    function cssClass(classes()) {
      return join(Object.keys(classes), " ");
    }

To fix this error, write `=` to make a parameter have a default value:

    const join = (string, delimiter = ",") =>
      string.join(delimiter);

Alternatively, remove the parentheses indicating a function call:

    function cssClass(classes) {
      return join(Object.keys(classes), " ");
    }
