# E0145: cannot import variable named keyword

An `import` statement can import a list of classes, functions, and variables. It
is a syntax error to import something with the same name as a keyword:

    // Exported using: export {cssClass as class};
    import {class} from "./css.mjs";

To fix this error, use `as` to name the imported variable different from the
exported name:

    // Exported using: export {cssClass as class};
    import {class as makeClass} from "./css.mjs";

Alternatively, change the name of the export, and ensure other importers use the
new name:

    // Exported using: export {cssClass};
    import {cssClass} from "./css.mjs";
