# E0142: missing property name after '.' operator

```config-for-examples
{
  "globals": {
    "goNuts": true
  }
}
```

The `.` operator accesses an object's property. It is a syntax error to omit a
property name after the `.` operator:

    try {
      goNuts();
    } catch {
      console.("couldn't handle deez nuts");
    }

To fix this error, write the property name after the `.`:

    try {
      goNuts();
    } catch {
      console.error("couldn't handle deez nuts");
    }
