# E0139: missing condition for while statement

```config-for-examples
{
  "globals": {
    "downloadURL": true
  }
}
```

A `while` statement has a condition which determines whether the body will
execute or not. It is an error to omit a `while` statement's condition:

    let name = '';
    while {
      name = prompt('What is your name?');
    }

    async function downloadURLWithRetries(url) {
      while {
        try {
          return await downloadURL(url);
        } catch {
          // Loop and try again.
        }
      }
    }

To fix this error, write the condition with parentheses after the `if` keyword:

    let name = '';
    while (name === '') {
      name = prompt('What is your name?');
    }

Alternatively, to write an infinite loop, write `for (;;)` instead of `while`:

    async function downloadURLWithRetries(url) {
      for (;;) {
        try {
          return await downloadURL(url);
        } catch {
          // Loop and try again.
        }
      }
    }
