# E0138: missing condition for if statement

```config-for-examples
{
  "globals": {
    "person": true
  }
}
```

An `if` statement has a condition which determines whether the body will execute
or not. It is an error to omit an `if` statement's condition:

    let firstName = person.firstName;
    let lastName = person.lastName;
    if {
      firstName = lastName;
    }

To fix this error, write the condition with parentheses after the `if` keyword:

    let firstName = person.firstName;
    let lastName = person.lastName;
    if (firstName === "") {
      firstName = lastName;
    }
