# E0136: cannot update variable with '+=' while declaring it

```config-for-examples
{
  "globals": {
    "x": true,
    "y": true,
    "z": true
  }
}
```

When declaring a variable with `const`, `let`, or `var`, you can set the
variable's initial value using `=`. It is a syntax error to use a compound
assignment operator instead of `=`:

    let i = 0;
    while (i < 100) {
      let i += 1;
      console.log(i % 15 ? i : "FizzBuzz");
    }

    const length *= Math.sqrt(x*x + y*y + z*z);

To fix this error, remove the `let` keyword:

    let i = 0;
    while (i < 100) {
      i += 1;
      console.log(i % 15 ? i : "FizzBuzz");
    }

Alternatively, replace the compound assignment operator with `=`:

    const length = Math.sqrt(x*x + y*y + z*z);
