# E0131: expected ',' between object literal entries

```config-for-examples
{
  "globals": {
    "axios": true,
    "cachingAdapter": true,
    "url": true
  }
}
```

In an object literal, entries are separated with a `,`. It is a syntax error to
separate entries with `;` instead:

    let response = await axios.get(url.toString(), {
      adapter: cachingAdapter;
      validateStatus(_status) {
        return true;
      };
      responseType: "stream"
    });

To fix this error, replace `;` with `,`:

    let response = await axios.get(url.toString(), {
      adapter: cachingAdapter,
      validateStatus(_status) {
        return true;
      },
      responseType: "stream"
    });
