# E0130: missing catch variable name between parentheses

```config-for-examples
{
  "globals": {
    "downloadURL": true
  }
}
```

A `try` statement can have a `catch` clause. The `catch` clause can define a
variable for the caught exception. It is a syntax error to omit the variable
name between a `catch` clause's parentheses:

    async function downloadURLWithRetries(url) {
      for (;;) {
        try {
          return await downloadURL(url);
        } catch () {
          // Loop and try again.
        }
      }
    }

To fix this error, remove the parentheses:

    async function downloadURLWithRetries(url) {
      for (;;) {
        try {
          return await downloadURL(url);
        } catch {
          // Loop and try again.
        }
      }
    }

Alternatively, write a variable name between the parentheses:

    async function downloadURLWithRetries(url) {
      for (;;) {
        try {
          return await downloadURL(url);
        } catch (e) {
          console.log(`retrying: ${e}`);
        }
      }
    }
