# E0125: missing header and body for 'for' loop

```config-for-examples
{
  "globals": {
    "collectBenchmarks": true,
    "runBenchmark": true
  }
}
```

It is a syntax error to write a `for` loop without a header (in parentheses) or
a body:

    for let i = 1; i < 100; ++i
    {
      console.log(i % 15 ? i : "FizzBuzz");
    }

To fix this error, put parentheses around the `for` loop's header:

    for (let i = 1; i < 100; ++i)
    {
      console.log(i % 15 ? i : "FizzBuzz");
    }
