# E0124: cannot declare variable named keyword

It is a syntax error to declare a variable named certain keywords like
`debugger` or `while`:

```javascript-ignoring-extra-errors
function parseVar(s) {
  let var = s.split()[0];
  let value = s.split()[1];
  return {var, value};
}
```

To fix this error, pick a different variable name:

    function parseVar(s) {
      let varName = s.split()[0];
      let value = s.split()[1];
      return {varName, value};
    }
