# E0119: missing body for catch clause

```config-for-examples
{
  "globals": {
    "parseConfig": true
  }
}
```

`catch` clauses in `try` statements require a body, which must be a list of
statements surrounded by `{` and `}`. It is a syntax error to omit the body of a
`catch` clause:

    const fs = require("fs");

    async function readConfig(configFilePath) {
      try {
        let data = await fs.promises.readFile(
          configFilePath,
          "utf-8",
        );
        return parseConfig(data);
      } catch (error)
    }

To fix this error, write the body of the `catch` statement, including `{` and
`}`:

    const fs = require("fs");

    async function readConfig(configFilePath) {
      try {
        let data = await fs.promises.readFile(
          configFilePath,
          "utf-8",
        );
        return parseConfig(data);
      } catch (error) {
        if (error.code === 'ENOENT') {
          return {};
        } else {
          throw error;
        }
      }
    }
