# E0114: unexpected token in variable declaration; expected variable name

```config-for-examples
{
  "globals": {
    "doMoreWork": true,
    "done": true
  }
}
```

Variables can be declared using a keyword such as `const`, `let`, or `var`. It
is a syntax error write anything except a variable name or a destructuring
pattern in a `const`, `let`, or `var` declaration:

    let sawFizzBuzz,
    100..toRange().forEach(i => {
      if (i % 15) {
        console.log(i);
      } else {
        console.log("FizzBuzz");
        sawFizzBuzz = true;
      }
    });

    let while (!done) {
      doMoreWork();
    }

To fix this error, replace `,` with `;`:

    let sawFizzBuzz;
    100..toRange().forEach(i => {
      if (i % 15) {
        console.log(i);
      } else {
        console.log("FizzBuzz");
        sawFizzBuzz = true;
      }
    });

Alternatively, remove the extra `const`, `let`, or `var` keyword:

    while (!done) {
      doMoreWork();
    }
