# E0112: unexpected token in export; expected 'export default ...' or 'export {name}' or 'export * from ...' or 'export class' or 'export function' or 'export let'

```config-for-examples
{
  "globals": {
    "Benchmark": true,
    "registerBenchmark": true
  }
}
```

It is a syntax error to write the `export` keyword without anything following:

    class SmallBenchmark extends Benchmark {}
    export {SmallBenchmark};
    class BigBenchmark extends Benchmark {}
    export

    for (let benchmark of [new SmallBenchmark(),
                           new BigBenchmark()]) {
      registerBenchmark(benchmark);
    }

To fix this error, complete the `export` statement:

    class SmallBenchmark extends Benchmark {}
    export {SmallBenchmark};
    class BigBenchmark extends Benchmark {}
    export {BigBenchmark};

    for (let benchmark of [new SmallBenchmark(),
                           new BigBenchmark()]) {
      registerBenchmark(benchmark);
    }
