# E0104: missing body for while loop

```config-for-examples
{
  "globals": {
    "isDigit": true,
    "isSorted": true,
    "shuffle": true
  }
}
```

`while` loops require a body, which must be a statement or `{` `}` surrounding a
list of statements. It is a syntax error to omit the body of a `while` loop:

    function bogoSort(array) {
      while (!isSorted(array))
    }

    function skipNumber(parser) {
      {
        parser.next();
      } while (isDigit(parser.peek()))
    }

To fix this error, write the body of the `while` loop:

    function bogoSort(array) {
      while (!isSorted(array))
        shuffle(array);
    }

Alternatively, make the `while` loop a `do`-`while` loop:

    function skipNumber(parser) {
      do {
        parser.next();
      } while (isDigit(parser.peek()))
    }
