# E0102: C-style for loops have only three semicolon-separated components

```config-for-examples
{
  "globals": {
    "width": true,
    "height": true,
    "draw": true,
    "pixelAt": true
  }
}
```

C-style `for` loops have three components, each separated by `;`: an
initializer, a condition expression, and an update expression. It is a syntax
error to write more than three components:

    for (let x = 0, y = 0;
         x < width && y < height;
         ++x;
         ++y) {
      draw(x, y, pixelAt(x, y));
    }

To fix this error, use `,` instead of `;` to separate expressions in the update
clause:

    for (let x = 0, y = 0;
         x < width && y < height;
         ++x, ++y) {
      draw(x, y, pixelAt(x, y));
    }
