# E0083: missing value for object property

```config-for-examples
{
  "globals": {
    "React": true,
    "children": true,
    "classes": true
  }
}
```

Object literals support a short-hand syntax which allows you to omit the value
of a property. It is a syntax error to omit the value if the key is computed or
is a keyword:

    let class_ = classes.join(" ");
    React.createElement(
      'div',
      { class },
      children,
    );

To fix this error, explicitly write a value for the property:

    let class_ = classes.join(" ");
    React.createElement(
      'div',
      { class: class_ },
      children,
    );
