# E0082: assigning to 'async' in a for-of loop requires parentheses

If a variable is named `async`, it is a syntax error to assign to that variable
in a `for`-`of` loop:

    async function awaitSequentially(asyncs) {
      let results = [];
      let async;
      for (async of asyncs) {
        results.push(await async);
      }
      return results;
    }

To fix this error, declare the variable inside the `for`-`of` loop:

    async function awaitSequentially(asyncs) {
      let results = [];
      for (let async of asyncs) {
        results.push(await async);
      }
      return results;
    }

Alternatively, rename the variable to something other than `async`:

    async function awaitSequentially(promises) {
      let results = [];
      let promise;
      for (promise of promises) {
        results.push(await promise);
      }
      return results;
    }
