# E0078: missing expression between parentheses

```config-for-examples
{
  "globals": {
    "eatCookies": true,
    "loadConfig": true,
    "putAwayCookieJar": true,
    "takeCookiesFromCookieJar": true
  }
}
```

Parentheses (`(` and `)`) serve three purposes in JavaScript:

* grouping in expressions
* calling functions
* function parameters

It is a syntax error to write `(` immediately followed by `)` (with nothing
between) when grouping in expressions:

    function fma(a, b, c) {
      return () + c;
    }

    const config = ();

    takeCookiesFromCookieJar()
      .then(cookies => eatCookies()
        .then(()));

To fix this error, write an expression between the parentheses:

    function fma(a, b, c) {
      return (a*b) + c;
    }

Alternatively, put the name of a function before the parentheses to call a
function with no arguments:

    const config = loadConfig();

Alternatively, write the rest of your arrow function:

    takeCookiesFromCookieJar()
      .then(cookies => eatCookies()
        .then(() => putAwayCookieJar()));

