# E0077: function call before declaration in blocked scope

A function can't be called before its declaration in block scope *in Safari*.

    f();
    {
        function f() {}
    }

To fix this error, move the function call below the block scope in which it is declared:

    {
        function f() {}
    }
    f();

Another way to fix this error, move the function out of the block scope in which it is declared.

    f();
    function f() {}
    {
    }
    
OR

    f();
    {
    }
    function f() {}
