# E0076: cannot declare and export variable with 'export default'

In modules, you can declare and export a variable at the same time. However, it
is a syntax error to declare and export a variable by default:

    export default let cache = {};

To fix this error, export by name, not by default:

    // Import using:
    // import {cache} from "./cache.mjs";
    export let cache = {};

Alternatively, to export by default, declare the variable then export it in a
separate statement. Note that this means importers of the variable cannot assign
to the variable (but the object can still be modified):

    // Import using:
    // import cache from "./cache.mjs";
    let cache = {};
    export default cache;
