# E0074: '.' operator needs a key name; use + to concatenate strings; use [] to access with a dynamic key

The right-hand side of the `.` operator must be a property name or a private
property name. It is an error for `.` to be followed by a literal:

    const ages = {
      "strager": 29,
      "Elon Musk": 50,
    };
    console.log("Musk's age:", ages."Elon Musk");

    const $favoriteLanguage = 'PHP';
    console.log('I love ' . $favoriteLanguage);

To fix this error, access properties using `[` `]` instead of `.`:

    const ages = {
      "strager": 29,
      "Elon Musk": 50,
    };
    console.log("Musk's age:", ages["Elon Musk"]);

Alternatively, concatenate strings using `+` instead of `.`:

    const $favoriteLanguage = 'PHP';
    console.log('I love ' + $favoriteLanguage);
