# E0073: missing function parameter list

Functions declared with `function` can have zero or more parameters. It is a
syntax error to omit the parameter list, including `(` and `)`, even if the
function has no parameters:

    class Doge {
      speak {
        console.log('many woofie');
      }
    }

    function visitDogPark {
      new Doge().speak();
    }

    setInterval(
      function {
        visitDogPark();
      },
      1000,
    );

To fix this error, add a pair of parentheses before `{` in the function:

    class Doge {
      speak() {
        console.log('many woofie');
      }
    }

    function visitDogPark() {
      new Doge().speak();
    }

    setInterval(
      function() {
        visitDogPark();
      },
      1000,
    );
