# E0070: commas are not allowed after spread parameter

In a function declaration, an extra `,` can be added to the end of the parameter
list. However, it is a syntax error to include an extra `,` after a spread
parameter:

    function sum(
      ...numbers,
    ) {
      return numbers.reduce((x, y) => x+y, 0);
    }

To fix this error, remove the extra `,`:

    function sum(
      ...numbers
    ) {
      return numbers.reduce((x, y) => x+y, 0);
    }
