# E0069: cannot declare 'await' inside async function

```config-for-examples
{
  "globals": {
    "closeOven": true,
    "fs": true,
    "openOven": true,
    "pidFile": true,
    "takePizza": true,
    "visitOven": true,
    "waitForPizza": true
  }
}
```

In non-strict mode, a variable can be named `await`. In strict mode and inside
`async` functions, it is a syntax error to use `await` as a variable name:

```javascript-ignoring-extra-errors
async function main() {
  const
  await fs.promises.writeFile(
    pidFile,
    process.pid,
  );
}

async function getCookedPizza(await) {
  visitOven();
  openOven();
  if (await) {
    await waitForPizza();
  }
  let pizza = takePizza();
  closeOven();
  return pizza;
}
```

To fix this error, complete the variable declaration preceeding `await`:

    async function main() {
      const pidFile = "./myapp.pid";
      await fs.promises.writeFile(
        pidFile,
        process.pid,
      );
    }

Alternatively, rename the variable to something other than `await`:

    async function getCookedPizza(wait) {
      visitOven();
      openOven();
      if (wait) {
        await waitForPizza();
      }
      let pizza = takePizza();
      closeOven();
      return pizza;
    }
