# E0063: missing operator between expression and arrow function

The left-hand side of `=>` must be a list of parameters. It is a syntax error if
the left-hand side looks like a function call:

    let fs = require("fs");
    let path = process.argv[2];
    fs.readFile(path (err, data) => {
      console.log(data);
    });

To fix this error, make the left-hand side of `=>` valid by adding an operator
(usually `,`) before the parameter list:

    let fs = require("fs");
    let path = process.argv[2];
    fs.readFile(path, (err, data) => {
      console.log(data);
    });
