# E0062: missing name or parentheses for function

```config-for-examples
{
  "globals": {
    "isEven": true
  }
}
```

If a statement begins with the `function` keyword, the declared function must
have a name. It is an error to start a statement with `function` but not give a
name to the function:

    function() {  // IIFE for our module
      class PublicClass {}
      class PrivateClass {}
      window.PublicClass = PublicClass;
    }()

    function (number) {
      return number % 2 === 0;
    }
    [1, 2, 3, 4].filter(isEven)
      .forEach(number => console.log(number));

To fix this error, wrap the IIFE (Immediately Invoked Function Expression) in
parentheses:

    (function() {  // IIFE for our module
      class PublicClass {}
      class PrivateClass {}
      window.PublicClass = PublicClass;
    }())

Alternatively, write the name of the function after the `function` keyword:

    function isEven(number) {
      return number % 2 === 0;
    }
    [1, 2, 3, 4].filter(isEven)
      .forEach(number => console.log(number));
