# E0058: variable used before declaration

```config-for-examples
{
  "globals": {
    "person": true
  }
}
```

Variables can be declared in many ways. For variables declared with `class`,
`const`, or `let`, it is an error to use the variable before/above its
declaration:

    let firstName = person.firstName;
    if (firstName === "") {
      firstName = lastName;
    }
    let lastName = person.lastName;

    function printAdjacentPairs(items) {
      let first = true;
      for (let current of items) {
        if (!first) {
          console.log(previous, current);
        }
        let previous = current;
        first = false;
      }
    }

To fix this error, move the variable's declaration up above its use:

    let firstName = person.firstName;
    let lastName = person.lastName;
    if (firstName === "") {
      firstName = lastName;
    }

Alternatively, declare the variable in an outer scope:

    function printAdjacentPairs(items) {
      let first = true;
      let previous;
      for (let current of items) {
        if (!first) {
          console.log(previous, current);
        }
        previous = current;
        first = false;
      }
    }
