# E0055: unmatched indexing bracket

```config-for-examples
{
  "globals": {
    "friends": true
  }
}
```

It is an error to write the indexing operator `[` without its matching `]`:

    for (let i = 0; i < friends.length; ++i) {
      let friend = friends[i;
      console.log[(`Hello, ${friend}!`);
    }

To fix this error, write the closing `]`, or remove the extraneous `[`:

    for (let i = 0; i < friends.length; ++i) {
      let friend = friends[i];
      console.log(`Hello, ${friend}!`);
    }
