# E0053: missing property name between '.' and '.'

```config-for-examples
{
  "globals": {
    "me": true
  }
}
```

The `.` operator accesses an object's property. It is a syntax error to write
two `.` in a row without a property name in between:

    console.log(`My bestie is ${me..name}`);

    let favoriteLanguage = 'Lua';
    console.log('I love ' .. favoriteLanguage .. '!');

To fix this error, write the property name between the two `.`s:

    console.log(`My bestie is ${me.bestFriend.name}`);

Alternatively, concatenate strings using `+` instead of `..`:

    let favoriteLanguage = 'Lua';
    console.log('I love ' + favoriteLanguage + '!');
