# E0046: unexpected characters in binary literal

Binary number literals start with `0b` and can only contain `0` or `1` digits
(and optionally an `n` to signify a `BigInt`). It is an error to include other
digits in binary number literals:

    let minInt16 = 0b1000000000000000N;
    let mouse = [0xf09f, 0b196];

To fix this error, fix or remove the extra digits or letters:

    let minInt16 = 0b1000000000000000n;

Alternatively, convert the binary number literal into a decimal, hexadecimal, or
octal number literal:

    let mouse = [0xf09f, 0xb196];
