# E0033: redeclaration of global variable

```config-for-examples
{
  "globals": {
    "windowlib": true,
    "$": {
      "shadowable": false
    },
    "window": {
      "shadowable": false
    }
  }
}
```

Global variables listed in `quick-lint-js.config` with `"shadowable": false`
cannot be re-declared in the global scope by a JavaScript module or script:

    let window = new windowlib.Window();

    let $ = (sel) => document.querySelector(sel);
    $('#banana')[0].peel();

To fix this error, choose a different variable name, or put the variable (and
code which uses the variable) into a function:

    let qsa = (sel) => document.querySelector(sel);
    qsa('#banana')[0].peel();

    function createUI() {
      let myWindow = new windowlib.Window();
    }
    createUI();
