# E0029: number literal contains trailing underscores

Number literals can contain underscores (`_`) to separate digits for legibility.
Underscores can only appear between digits, not after all digits:

    let PIN_UART = 0b00_01;
    let PIN_LED  = 0b01_;
    const tau = 3.1415926536__ * 2;

To fix this error, remove the trailing underscores, or write more digits:

    let PIN_UART = 0b00_01;
    let PIN_LED  = 0b01_01;
    const tau = 3.1415926536 * 2;
