# E0027: missing semicolon after statement

```config-for-examples
{
    "globals": {
        "fadeIn": true
    }
}
```

If multiple statements are on the same line, they must be separated with a
semicolon (`;`):

    console.log("hello") console.log("world")

    $("#message").text("Logged in")fadeIn()

    function stop() { /*...*/ }
    let shouldStop = false
    if (shouldStop) stop() return

To fix this error, add a semicolon, break the line, or use a dot (`.`) to call a
method:

    console.log("hello")
    console.log("world")

    $("#message").text("Logged in").fadeIn()

    function stop() { /*...*/ }
    let shouldStop = false
    if (shouldStop) { stop(); return }
