# E0025: missing comma between object literal entries

Object literal entries, including methods, are separated by commas. It is an
error to write two entries without a comma in between:

    const snuffles = {
      age: 7
      meow() {
        console.log("😾")
      }
      eat() {
        console.log("😸")
      }
    }

To fix this error, include commas:

    const snuffles = {
      age: 7,
      meow() {
        console.log("😾")
      },
      eat() {
        console.log("😸")
      }
    }
